
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Frame for the game Checkers. The frame contains the game
     board and necessary buttons and information fields. */
public class Checkers extends JFrame {
	// The layout and constraint variables for this frame
    	Container cPane= getContentPane();
		GridBagLayout gb;
		GridBagConstraints gbc;

	// Components that go in the frame
		CheckersSquare[][] board; // The 8 x 8 game board
	
		JLabel redsLabel= new JLabel("red pieces ", SwingConstants.CENTER);
		JLabel blacksLabel= new JLabel("black pieces ", SwingConstants.CENTER);
		JLabel reds= new JLabel("0",SwingConstants.CENTER);   // Number of white pieces on board
		JLabel blacks= new JLabel("0",SwingConstants.CENTER); // Number of black pieces on board
		JLabel whoPlays= new JLabel("Red to play ",SwingConstants.CENTER);
		JLabel nextTask= new JLabel("Select piece to move",SwingConstants.CENTER);
		JLabel title= new JLabel("  THE GAME OF CHECKERS  ",SwingConstants.CENTER);
		JTextArea helpText= null; // To contain an explanation, when requested
		
	// The buttons
		JButton bNewGame= new JButton("New game");
		JButton bQuit= new JButton("Quit");
		JButton bHelp= new JButton("Help");

	IntLabel redCount= new IntLabel(0, reds);     // Number of red pieces on the board
	IntLabel blackCount= new IntLabel(0, blacks); // Number of black pieces on the board

	// clickflag describes the clicks made by the user thus far in making
	// a move:
	//   = 0: No piece has been chosen (clicked on). For all
	//		  squares, field toBeMoved is false.
	//   = 1: A click, on a piece of color colorToPlay, has been made.
	//        oldSq is the square of the piece to be moved, and it is
	//		  highlighted (i.e. oldSq.toBeMoved=true). For all other
	//        squares, field toBeMoved is false.
		int clickflag = 0;
		CheckersSquare oldSq;

	// These variables have values CheckersSquare.RED or CheckersSquare.BLACK
		int colorToPlay; 	// player (i.e. color) to play
		int otherColor;		// the other color

	/** Constructor: An 8 x 8 checkerboard, with three buttons and some
	    pieces of information */
	public Checkers() {
		super("Checkers");
		gb= new GridBagLayout();
		gbc= new GridBagConstraints();
		setFont(new Font("Dialog", Font.PLAIN, 10));
		cPane.setLayout(gb);
		MouseClickListener mcl= new MouseClickListener();
	
		gbc.fill=  GridBagConstraints.NONE;
		int i;
		int j;

		// Create and place the 8*8 squares in the frame
			board= new CheckersSquare[8][8];
			for (i= 0; i != 8; i= i+1)
				for (j= 0; j != 8; j= j+1) {
					board[i][j]= new CheckersSquare(i,j);
					add(board[i][j], gb, gbc, 2*i,2*j, 2,2, 0,0);
					board[i][j].addMouseListener(mcl);
				}
	
		// Setting gbc.fill to BOTH ensures that the buttons fill their entire space.
		// Without this assignment, buttons would take the minimum space possible.
		// Comment out this statement and execute to see this.
		gbc.fill=  GridBagConstraints.BOTH;
	
		// Register a listener for the New Game button and add the button.
			bNewGame.addActionListener(new ActionListener() {
		    	public void actionPerformed(ActionEvent e) {newGame();}
		   	 });
			add(bNewGame, gb, gbc, 2*8,0, 2,2, 0,0);
		
		// Register a listener for the Quit button and add the button.
			bQuit.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent e) {
			       dispose();
			       System.exit(0);
			    }
		    });
			add(bQuit, gb, gbc, 2*8,2, 2,2, 0,0);
	
		// Register a listener for the Help button and add the button.
			bHelp.addActionListener(new ActionListener() {
		    	public void actionPerformed(ActionEvent e) {
		       		// Handle press of "Help"
			      		if (helpText != null) {
				     	// Help field already exists, so remove it and return
					    	cPane.remove(helpText);
					    	helpText= null;
					    	pack();
					    	return;
			      		}
			      	helpText= new JTextArea("This is the game of checkers. We " +
					  "assume you know how to play. To move a piece, first\n" +
					  "click the mouse on the piece you want to move. Note " +
					  "that this piece is highlighted. Then\n" +
					  "click on the square to which you " +
					  "want to move it. If you decide to change the piece you \n" +
					  "want to move, just click on a " +
					  "different piece (of the same color).\n" +
					  "\n" +
					  "One change in the game: You can't jump two or more pieces at once. " +
					  "Try changing the program\nto do this --it's a big change.\n" +
					  "\n" +
					  "Another possible rule: if a jump can be made, it MUST be made. " +
					  " This is not implemented.\n" + 
					  "Try to implement it if you want.\n" +
					  "\nA king is shown with a white ring around it", 10, 40);
			      	helpText.setEditable(false);
			      	gbc.fill= GridBagConstraints.BOTH;
			      	add(helpText, gb, gbc, 0, 2*8+1, 2*8+2,1, 0,0);
			      	setSize(400,400);
			     	 pack();
		    	}});
			add(bHelp, gb, gbc, 2*8,4, 2,2, 0,0);
		
		// Place labels for the numbers of white and black pieces
			gbc.fill=  GridBagConstraints.HORIZONTAL;
			gbc.anchor= GridBagConstraints.SOUTHWEST;
			add(redsLabel, gb, gbc, 2*8,2*4, 2,2, 0,0);
			add(blacksLabel, gb, gbc, 2*8,2*5, 2,2, 0,0);
			gbc.anchor= GridBagConstraints.NORTHWEST;
			add(reds,      gb, gbc, 2*8,2*5+1, 2,2, 0,0);
			add(blacks,    gb, gbc, 2*8,2*6+1, 2,2, 0,0);
			add(title,     gb, gbc, 2*8, 2*7, 2,2,0,0);
	
		// Place the "whose play is it" and cursor label
			add(whoPlays,    gb, gbc, 2*8,2*3, 2,1, 0,0);
			add(nextTask,  gb, gbc, 2*8,2*3+1, 2,1, 0,0);
	
		pack();
		setLocation(150,50);
		newGame();
		show();
		setResizable(false);
	}

	/** Add component c to gbl (with constraints gbc) at position (x,y).
	    Component c takes w columns and r rows, and is weighted (wx, wy). */
	private void add(Component c, GridBagLayout gbl,
				GridBagConstraints gbc,
				int x, int y, int w, int h, int wx, int wy) {
		gbc.gridx= x;
		gbc.gridy= y;
		gbc.gridwidth= w;
		gbc.gridheight= h;
		gbc.weightx= wx;
		gbc.weighty= wy;
		gbl.setConstraints(c, gbc);
		cPane.add(c);
	}
	
	private class MouseClickListener extends MouseAdapter {
    	public void mouseReleased(MouseEvent e) {
     	  if (!(e.getComponent() instanceof CheckersSquare))
         	 return;
       	  if (clickflag == 0) {
		   	 processSquareClick((CheckersSquare)(e.getComponent()));
		   	 return;
	   	  }
	   	  if (clickflag == 1) {
		     processClickTwo((CheckersSquare)(e.getComponent()));
		     return;
	      }
 		}
	}
	
	/** Set the board up for a new game */
	public void newGame() {
		// Pick up the pieces from all the squares
			for (int i= 0; i != 8; i= i+1)
				for (int j= 0; j != 8; j= j+1)
					board[i][j].pickUpPiece();
			nextTask.setText("Select piece to move");
			clickflag = 0;
		// TASK 8.1: FINISH THIS
		// Place red and black pieces in initial configuration
			for (int i= 0; i<=6; i= i+2) {
				board[i+1][0].placePiece(CheckersSquare.RED);  // row 0
				board[i]  [1].placePiece(CheckersSquare.RED);  // row 1
				board[i+1][2].placePiece(CheckersSquare.RED);  // row 2
			}
		// Set the number of red and number of black pieces to 12
			redCount.setInt(12);
			blackCount.setInt(12);
		colorToPlay= CheckersSquare.BLACK;
		otherColor= CheckersSquare.RED;
		changeTurn();
	}

	/** return the sign of v */
	private int sign(int v) {
  	  if (v > 0)
		return 1;
   	  if (v < 0)
		return -1;
   	  return v;
    }
    
	/** Attempt to move piece from square oldSq to square newSq.
	    If not possible, return false.
	    If possible, make the move and return true. */
	private boolean validMove(CheckersSquare oldSq, CheckersSquare newSq) {
		// TASK 8.3 (Part 1). Implement this statement-comment.
		// Return false if it's an attempt to move to a red square or
    	// if it's an attempt to move to an already-occupied square
            
    	
    	// TASK 8.3 (Part 1). Implement this statement-comment.
    	// If this is a valid non-jump move, then make the move
    	// and return true. Making the move requires: (0) picking up
    	// the piece, (1) putting it down on the new square, and
    	// (2) promoting it to a new king if necessary.
			
			
		// TASK 8.5 (Part II). Implement this statement-comment.
   		// If this is a valid jump move, then make the move
		// and return true. Making the move requires: (0) picking up
		// the piece, (1) putting it down on the new square, (1) picking
		// up the piece jumped (and subtracting 1 from the number of
		// pieces of that color), and (2) promoting the new piece to
		// a king if necessary 

			
		// The move is invalid, so return false
			return false;
    }
    
	// Return "the move from oldSq to newSq is a valid non-jump
	// move for player colorToPlay". Assume that oldSq contains a
	// a piece of colorToPlay and that newSq is an empty black square
	private boolean isValidNonjump(CheckersSquare oldSq,
							   	   CheckersSquare newSq) {
		// TASK 8.2 IMPLEMENT THE STATEMENT COMMENTS
		int dx = newSq.col - oldSq.col;
    	int dy = newSq.row - oldSq.row;
    	return false;
   
   		// Return false if the move is not a move to an adjacent
		// row and column
			
    	// Return true if this is a King (which can go in any direction)
    		
    	// The piece is not a king. Return value of "the piece moves
    	// forward (and not backward)"
    	
	}

	// Return "the move from oldSq to newSq is a valid jump
	// move for player colorToPlay". Method assumes that oldSq
	// contains a piece and that newSq is an empty black square
	private boolean isValidjump(CheckersSquare oldSq,
							CheckersSquare newSq) {
		int dx = newSq.col - oldSq.col;
    	int dy = newSq.row - oldSq.row;
    	return false;
   
   		// TASK 8.4. Implement this statement-comment
   		// Return false if the move is not a move of 2 columns
		// and two rows
		
    	
    	// TASK 8.4. Implement this statement-comment
   		// Return false if there is not a piece of the other color
    	// between oldSq and newSq.
 
    
    	// TASK 8.4. Implement this statement-comment
   		// Return true if this is a King (which can go in any direction)
    		
    
    	// TASK 8.4. Implement this statement-comment
   		// The piece is not a king. Return value of "this move is a
    	// forward (and not backward) move"
    	
    	
 	}


	/** If the piece in square sq is not a king and is in the
	    last row for its color, change it to a King. Changing it
	    to a king should be done by picking the piece up and then
	    placing a king on the square */
	public void promoteToKing(CheckersSquare sq) {
		if ((sq.row==7) && sq.contents()==CheckersSquare.RED) {
			sq.pickUpPiece();
			sq.placePiece(CheckersSquare.REDKING);
			return;
		}
		if ((sq.row==0) && sq.contents()==CheckersSquare.BLACK) {
			sq.pickUpPiece();
			sq.placePiece(CheckersSquare.BLACKKING);
		}	
	}

	/** Switch player (i.e. switch colorToPlay and otherColor) and
	    set clickflag for a new move */
	public void changeTurn() {
		int temp= colorToPlay;
		colorToPlay= otherColor;
		otherColor= temp;
		if (colorToPlay == CheckersSquare.RED) {
			whoPlays.setText("Red to play");
			setCursor(Cursor.getPredefinedCursor(TEXT_CURSOR));
		}
		else {
			whoPlays.setText("Black to play");
			setCursor(Cursor.getPredefinedCursor(HAND_CURSOR));
		}
		clickflag= 0;
	}


	/** clickflag=1. If the pieces on oldSq and newSq have the same color,
	    then switch to moving the piece on newSq. Otherwise, attempt to
	    move the piece from oldSq to square newSq. If not possible, give
	    error message; if possible, do it and switch players. */
	public void processClickTwo(CheckersSquare newSq) {
		enableBoard(false);
		// Change the piece to move and return,if the pieces on oldSq
		// and newSq are the same color
			if (newSq.isSameColor(colorToPlay)) {
				oldSq.setToBeMoved(false);
				oldSq= newSq;
				oldSq.setToBeMoved(true);
				nextTask.setText("Select destination");
				enableBoard(true);
	    		return;
	    	}
		// If newSq is not empty, give error message and return
			if (newSq.contents() != CheckersSquare.EMPTY ) {
	    		enableBoard(true);
	    		nextTask.setText("Invalid destination. Retry");
	    		return;
	    	}
		if (validMove(oldSq, newSq)) {
			oldSq.setToBeMoved(false);
			clickflag = 0;
			nextTask.setText("Select piece to move");
			changeTurn();
			enableBoard(true);
			return;                
		}
		// Move was not handled. Tell user to retry the move
	    	nextTask.setText("Invalid destination. Retry");
			enableBoard(true);
   }
    
	/** Process the first click by user in making a move --clickflag=0.
	    The click is in square sq.
	    If the click is on an empty square or on a piece of wrong color,
	    give a message and ask user to try again. */
	public void processSquareClick(CheckersSquare sq) {
		enableBoard(false);
		if (sq.contents() == CheckersSquare.EMPTY ||
	    	!sq.isSameColor(colorToPlay)) {
				enableBoard(true);
				nextTask.setText("Invalid choice. Retry");
				return;
		}
		oldSq= sq;
		sq.setToBeMoved(true);
		clickflag = 1;
		nextTask.setText("Select destination");
		enableBoard(true); 
	}
	
	/** If en is true, enable the board squares; otherwise disable them. */
	public void enableBoard(boolean en) {
		for (int i= 0; i != 8; i= i+1)
			for (int j= 0; j != 8; j= j+1)
				board[i][j].setEnabled(en);
	}			
}
